#include <cassert>
#include <cstdio>
#include <algorithm>

const long long INF = 100000000000000;

const int N = 200005;
int n, m;
long long x[N * 2], d, until[N][2], until0;
bool good[N][2];
std::pair<long long, long long> ev[N];
std::vector<std::pair<int, bool> > vals[N];

int locate(long long p) {
	return std::lower_bound(x, x + m, p) - x;
}

bool update(long long cur, long long t) {
	long long R = INF, L = -INF;
	for (int i = 0; i < n && ev[i].first <= t; ++i) {
		if (ev[i].first + ev[i].second - d < t + cur && t + cur < ev[i].first + ev[i].second + d) 
			R = std::min(R, cur + t - ev[i].first);
		if (ev[i].first - ev[i].second - d < t - cur && t - cur < ev[i].first - ev[i].second + d) 
			L = std::max(L, cur - t + ev[i].first);
	}
	bool ok = 0;
	if (L <= 0 && 0 <= R) {
		if (cur <= 0 && -cur <= t && until0 > t + cur) return 1;
		if (cur > 0 && cur <= t && until0 > t - cur) return 1;
	}
	for (int i = 0; i < n; ++i) if (ev[i].first <= t) {
		long long pos = ev[i].second - d;
		for (int tt = 0; tt < 2; ++tt) {
			if (good[i][tt] && L <= pos && pos <= R) {
				if (cur <= pos && ev[i].first + pos - cur <= t && until[i][tt] > t - pos + cur) ok = 1;
				if (cur > pos && ev[i].first + cur - pos <= t && until[i][tt] > t - cur + pos) ok = 1;
			}
			pos += 2 * d;
		}
	}
	return ok;
}

bool test() {
	for (int i = 0; i < n; ++i) {
		x[i << 1] = ev[i].second - d;
		x[i << 1 | 1] = ev[i].second + d;
		good[i][0] = good[i][1] = 0;
	}
	x[n * 2] = 0;
	std::sort(x, x + n * 2 + 1);
	m = std::unique(x, x + n * 2 + 1) - x;
	until0 = INF;
	for (int i = 0; i < m; ++i) {
		vals[i].clear();
	}
	for (int i = 0; i < n; ++i) {
		if (good[i][0] = update(ev[i].second - d, ev[i].first)) {
			until[i][0] = INF;
			vals[locate(ev[i].second - d)].push_back(std::make_pair(i, 0));
		}
		if (good[i][1] = update(ev[i].second + d, ev[i].first)) {
			until[i][1] = INF;
			vals[locate(ev[i].second + d)].push_back(std::make_pair(i, 1));
		}
		for (int j = 0; j < m; ++j) if (ev[i].second - d < x[j] && x[j] < ev[i].second + d) {
			if (!x[j] && until0 == INF) until0 = ev[i].first;
			while (!vals[j].empty()) {
				until[vals[j].back().first][vals[j].back().second] = ev[i].first;
				vals[j].pop_back();
			}
		}
	}
	for (int i = 0; i < n; ++i) {
		long long pos = ev[i].second - d;
		for (int t = 0; t < 2; ++t) {
			if (good[i][t] && until[i][t] == INF && ev[i].first) {
				return 1;
			}
			pos += 2 * d;
		}
	}
	if (until0 == INF) return 1;
	return 0;
}

int main() {
	scanf("%d", &n);
	for (int i = 0; i < n; ++i) {
		scanf("%lld%lld", &ev[i].first, &ev[i].second);
		ev[i].first *= 2;
		ev[i].second *= 2;
	}
	std::sort(ev, ev + n);
	int l = 0, r = 5000000000;
	while (l < r) {
		d = l + r >> 1;
		if (test()) l = d + 1;
		else r = d;
	}
	--l;
	printf("%lld", l / 2);
	if (l & 1) printf(".5");
	printf("\n");
	return 0;
}